#ifndef __C_SIMNETLAYER_H
#define __C_SIMNETLAYER_H

#define WIN32_LEAN_AND_MEAN

#include "Interfaces/cLayer.h"
#include "Interfaces/cCallback.h"
#include "cSimEndpoint.h"
#include "cSimNetLayerParam.h"

class cSimEngine;
class cSimNode;
class cProtocolStack;
class cMsgBuffer;
class cRegisterList;

/*
 * cSimNetLayer.h
 *
 * Simulated network layer.
 */
class cSimNetLayer : public cLayer, public cDeliver, public cCallback
{

  public:

	/* -- Callback Methods -- */
	void Callback(HANDLE eventHandle, void* param);

	/* --Deliver Methods-- */
	bool Deliver(cEndpoint* sender, cMsgBuffer* buffer, int messageType);

	// Initialization
	bool Init(cLayer* layerBelow, cParam* param);
	bool Cleanup();

	// Sending of messages.
	bool Send(cGroup* dest, cMsgBuffer* buffer, int messageType);

	bool Schedule() { return true; }

	// Callback Registration/Unregisteration
	bool		RegisterDeliverCallback(cHandle* handle, cDeliver* callback);
	bool		UnregisterDeliverCallback(cHandle handle);
	bool		RegisterViewCallback(cHandle* handle, cView* callback);
	bool		UnregisterViewCallback(cHandle handle);
	bool		RegisterErrorCallback(cHandle* handle, cErrorCallback* callback);
	bool		UnregisterErrorCallback(cHandle handle);

  private:

	// Utility functions
	bool	_DeliverErrorCallback(cObject* obj, unsigned int type);

	// Register lists
	cRegisterList*	mRegisterList;	
	cRegisterList*  mErrorCallbackList;

	// Members
	cHandle			    mLayerBelowHandle;
	cProtocolStack*		mProtocolStack;
	cSimEngine*			mEngine;
	cSimEndpoint*		mMyEndpoint;
	HANDLE				mNetEvent;
};

#endif
